## -*-Tcl-*- (install) (nowrap)
# File : "mfMode.tcl"
#                        Created : 1999-03-28 14:31:57
#              Last modification : 2001-11-09 18:02:37
# Author : Bernard Desgraupes
# e-mail : <berdesg@easynet.fr>
# www : <http://perso.easynet.fr/~berdesg/>
# Description : 
# Metafont Mode is a mode for the text editor Alpha: it is designed  to  make
# writing, processing and testing  of  Metafont  source  files  much  easier.
# Metafont is the programming language written, as a  companion  to  TeX,  by
# Donald Knuth in order to create characters, fonts, font families (and  many
# others things). Once Metafont mode is installed, the opening of a  Metafont
# source file (i-e with extension .mf) invokes a new menu (called Metafont !)
# in the menu bar with the following features :
# -  easy insertion of all the basic Metafont commands (with electric stops)
# -  syntax coloring
# -  file marking
# -  capacity to process a source file from within Alpha with various  flags,
# printer modes, input base files
# -  editing the log file
# - capacity to make the pk file, to make the dvi from the generic  font,  to
# view the dvi, to convert dvi to ps from within Alpha
# -  capacity to make and to edit the property list of a font
# -  capacity to process an entire folder of mf source files
# -  ready to use template for a new font
# -  key bindings to choose the processing mode, process files etc.
# -  advanced keywords completion
# -  command clicking on a word leads to its definition
# -  option clicking on the title bar of a window brings a list  of  .mf  and
# .log files at the same level or in a selected folder  and  allows  to  edit
# them.
# 
# As of this release, both <CMacTeX Metafont> and <OzMetafont> are  supported
# (together with their respective gftopk, gftodvi, dvipreviewer and tftopl).
# 
# Read the instructions in the Metafont Help file (found in Alpha's Help menu)
# 
# The Metafont Mode package for Alpha is made of the following files and 
# will not work properly (will not work at all) if any of them is missing :
# 	    mfCommands.tcl
# 	    mfEngine.tcl
# 	    mfMacros.tcl
# 	    mfMenus.tcl
# 	    mfMode.tcl
# 	    mfPostprocess.tcl
# 	    mfUtilities.tcl
#  
# (c) Copyright : Bernard Desgraupes, 1999, 2000, 2001
#         All rights reserved.
# This software is free software. See licensing terms in the Metafont Help file.
#  
##

alpha::mode Mf 2.0.2 mfMenu {*.mf *.vpl} mfMenu {
	alpha::package require AlphaTcl 7.4
	addMenu mfMenu "Metafont" Mf
} maintainer {
	"Bernard Desgraupes" <berdesg@easynet.fr> <http://perso.easynet.fr/~berdesg/alpha.html> 
} uninstall this-file help {file "Metafont Help"}


namespace eval Mf {}

# Preferences
# ===========

newPref f wordWrap {0} Mf
# Set this flag if you want your source file to be marked automatically when it is opened.
newPref f autoMark {1} Mf
# Set this flag if you want the tab key to behave electrically (to jump from a bullet
# to the next one in templates for instance).
newPref f electricTab {1} Mf
# Metafont particular processing option.
newPref f gfcorners 0 Mf  Mf::shadowPrefs
# Metafont particular processing option.
newPref f imagerules 0 Mf   Mf::shadowPrefs
# Metafont particular processing option.
newPref f nodisplays 0 Mf   Mf::shadowPrefs
# Metafont particular processing option.
newPref f notransforms 0 Mf   Mf::shadowPrefs
# Metafont particular processing option.
newPref f screenstrokes 0 Mf   Mf::shadowPrefs
# Metafont particular processing option.
newPref f screenchars 0 Mf   Mf::shadowPrefs
# Set this flag to build a list of source files.
# You will have to set the path to the top folder with the PathToSourceFile
# preference. Folders can be nested : use the NestingDepth pref to say how deep.
newPref f buildSourceFiles 0 Mf Mf::shadowList
# If this flag is set all the output will go in the MFworkFolder
# instead of going in the same folder as the source file. 
# This feature works only with CMacTeX Metafont (not OzMetafont).
newPref f useWorkFold 0 Mf
# How to handle comments continuation
newPref v commentsContinuation 2 Mf "" \
  [list "only at line start" "spaces allowed" "anywhere"] index
# Name of the printer mode for Metafont : for instance cx at 300dpi, 
# canonex at 600dpi etc. Default is canonex.
newPref v mfModeForPrinter canonex Mf
# Prefix for comments in Metafont source files.
newPref v prefixString {% } Mf
# Regular expression used in the Functions pop-up menu 
# (above the M pop-up menu, top right of the current window).
newPref v funcExpr {^(def|vardef|primarydef|secondarydef|tertiarydef) [^\(=@;\r]+} Mf
# Metafont mode's notion of what is a word.
newPref v wordBreak {[_\w]+} Mf
newPref v wordBreakPreface {[^_\w]} Mf
# To customize the denomination of the beginchar macro.
newPref v userBeginchar beginchar Mf
# To customize the denomination of the endchar macro.
newPref v userEndchar endchar Mf
# Default colo(u)rs for the keywords
newPref v commentColor red Mf
newPref v keywordColor blue Mf
newPref v stringColor green Mf
newPref v primitivesColor magenta Mf
# Access path of the Metafont application.
newPref v mfAppSig {} Mf Mf::rebuildSubmenus
# Folder where Metafont sends its output to.
newPref folder MfworkFolder $HOME Mf
# Access path of file modes.mf defining the parameters' values for 
# all possible Metafont modes.
newPref file pathToModesMfFile {} Mf
# Access path of file plain.mf defining the Metafont's basic macros.
newPref file pathToPlainMfFile {} Mf
# Set here the location of a folder containing mf files you are working on.
# It may contain subfolders : specify the depth with 
# the nestingDepth pref.
newPref file pathToSourceFolder {} Mf Mf::shadowList
# Choose the depth of subfolders nesting in the main source folder.
newPref v nestingDepth {3} Mf Mf::shadowList


# Initialization of some variables
# ================================

set mf_params(tailfilename) [file tail [win::Current]]
set mf_params(outputfolder) $MfmodeVars(MfworkFolder)
set mf_params(chosenMode) proof
set mf_params(mfwd) $HOME
set mf_params(basefile) ""
set mf_params(tfmfile) ""
set mf_params(postfile) ""
set mf_params(currentdir) ""
set mf_params(filenames) ""
set mf_params(convertidx) 0
set mf_params(done) 0
set mf_params(tfmdone) 0
set mf_params(mag) 1
foreach v [list magstep magflag magstepflag basefileflag mfset] {
	set mf_params($v) 0
    }
foreach v [list gfcorners imagerules nodisplays notransforms screenchars screenstrokes] {
	set mf_params($v) [set MfmodeVars($v)]
    }
foreach v [list prefixtfm prefixpl prefixgf \
  prefixdvi prefixlog prefixrmall fromfolder] {
    set mf_params($v) "("
}
set mf_params(mfsymb) ""
set mf_params(convertopt) [list "a file" "a folder" "current folder"]
set Mf::commentCharacters(General) "%"
set Mf::commentCharacters(Paragraph) [list "%% " " %%" " % "]
set Mf::commentCharacters(Box) [list "%" 1 "%" 1 "%" 3]


proc mfMenu {} {}

hook::register activateHook Mf::rebuildSubmenus Mf


# -------------------------------------------------------------------------
# Select the Metafont application when using this mode for the first time
# -------------------------------------------------------------------------

if {${alpha::platform} == "alpha" && $MfmodeVars(mfAppSig)== ""} {
    set mfsignlist [list "CMacTex mf" "OzMetafont"]
    if {[catch {set sig [listpick -p "Select your Metafont application"  $mfsignlist]}]} {return}
    switch $sig {
	"CMacTex mf" {set mfAppSig "CMT3"}
	"OzMetafont" {set mfAppSig "OzMF"}
    }
    set oldMode $mode
    set mode Mf
    prefs::removeArrayElement MfmodeVars mfAppSig
    set MfmodeVars(mfAppSig) $mfAppSig
    prefs::addArrayElement MfmodeVars mfAppSig $mfAppSig
    set mode $oldMode
    catch {unset mfsignlist sig oldMode}
}



# Mode specific goodies
# =====================
# 
# Syntax Coloring
# ---------------
# We define two groups of keywords :
# -  the macros of the Metafont plain format. Default color : blue
# -  the Metafont primitives. Default color : magenta
# These colors can be modified in the mode prefs : see "Keyword Color" 
# and "Primitives Color".

set mfKeyWords { 
abs beginchar blacker blankpicture bot bye byte capsule_def ceilling 
change_width checksum clear_pen_memory clearit clearpen 
clearxy codingscheme counterclockwise cullit currentpen currentpicture 
currenttransform currentwindow cutdraw cutoff decr define_blacker_pixels 
define_good_x_pixels define_good_y_pixels define_pixels define_whole_pixels 
direction directionpoint displaying ditto dotprod downto draw drawdot endchar 
eps epsilon erase exitunless extra_beginchar extra_endchar extraspace face 
family fill filldraw fix_units flex font_coding_scheme font_extra_space 
font_identifier font_normal_shrink font_normal_space font_normal_stretch 
font_quad font_size font_slant font_x_height fullcircle gfcorners gobble 
gobbled good.bot good.lft good.rt good.top good.x good.y grayfont halfcircle 
hide hround identity imagerules incr infinity interact interpath intersectionpoint 
inverse italcorr join_radius label labelfont labels lft loggingall makegrid 
makelabel max min mod mode_setup nextlarger nodisplays notransforms numtok 
o_correction of openit or pen_bot pen_lft pen_rt pen_top penlabels 
penpos penrazor penspeck pensquare penstroke pickup pixels_per_inchs proofoffset 
proofrule proofrulethickness quad quartercircle range reflectedabout relax rep 
rotatedaround round rt savepen screen_cols screen_rows screenchars screenrule 
screenstrokes secondary shipit showit shrink slant slantfont solve space stop 
stretch superellipse tensepath text thru titlefont tolerance top tracingall 
tracingnone undraw undrawdot unfill unfilldraw unitpixel unitsquare upto 
varchar vround whatever xheight 
}

regModeKeywords  -e {%} -c $MfmodeVars(commentColor) \
  -k $MfmodeVars(keywordColor)  -s $MfmodeVars(stringColor) Mf $mfKeyWords

set mfprimKeyWords { 
ASCII addto also and angle at atleast autorounding batchmode
begingroup boolean char character charcode chardp chardx chardy charexists
charext charht charic charlist charwd comment contour controls cosd cull curl
cycle day decimal def delimiters designsize designunits directiontime
display doublepath dump dropping else elseif end enddef endfor
endgroup endinput errhelp errmessage errorstopmode everyjob exitif
expandafter expr extensible false fi fillin floor fontdimen fontmaking
fontname fontdsize fontat forever forsuffixes from granularity
headerbytes hex hppp if inner input interim intersectiontimes inwindow
jobname keeping kern known krn length let lig ligtable makepath
makepen map mapfont message mexp mlog month newinternal nonstopmode
normaldeviate not nullpen nullpicture numeric numspecial oct odd
openwindow outer pair parameter path pausing pen pencircle penoffset picture
point postcontrol precontrol primary primarydef proofing quote
randomseed readstring reverse rotated save scaled scantokens
scrollmode secondarydef setchar shifted shipout show showdependencies
showstats showstopping showtoken showvariable sind slanted smoothing
special sqrt step str string subpath substring suffix tension tertiary
tertiarydef time to totalweight tracingcapsules tracingchoices
tracingcommands tracingedges tracingequations tracingmacros
tracingonline tracingoutput tracingpens tracingrestores tracingspecs
tracingstats tracingtitles transform transformed true turningcheck
turningnumber uniformdeviate unknown until vardef vppp warningcheck
withpen withweight xoffset xpart xscaled xxpart xypart year yoffset
ypart yscaled yxpart yypart zscaled 
}

regModeKeywords  -a -k $MfmodeVars(primitivesColor) Mf $mfprimKeyWords

# We store the primitives in a list which will be used below by the Mf::DblClick proc.
set mfPrimList [split $mfprimKeyWords]


# Completions
# -----------

set completions(Mf) {contraction Input completion::cmd completion::electric}

set Mfcmds [lsort -ignore [concat $mfKeyWords $mfprimKeyWords]]

# We don't need mfprimKeyWords and v anymore :
unset mfKeyWords
unset mfprimKeyWords

  
# # # # # Abbreviations # # # # #
set Mfelectrics(bc)   "kill0$MfmodeVars(userBeginchar)(\"\",,,);\"\";\n\n\n$MfmodeVars(userEndchar);\n"
set Mfelectrics(bg)   "kill0begingroup \n\nendgroup;\n"
set Mfelectrics(dp) "kill0define_pixels();\n"
set Mfelectrics(dbp) "kill0define_blacker_pixels();\n"
set Mfelectrics(dcp) "kill0define_corrected_pixels();\n"
set Mfelectrics(dgxp) "kill0define_good_x_pixels();\n"
set Mfelectrics(dgyp) "kill0define_good_y_pixels();\n"
set Mfelectrics(dhcp) "kill0define_horizontal_corrected_pixels();\n"
set Mfelectrics(dwp) "kill0define_whole_pixels();\n"
set Mfelectrics(dwvp) "kill0define_whole_vertical_pixels();\n"
set Mfelectrics(dwvb) "kill0define_whole_vertical_blacker_pixels();\n"
set Mfelectrics(sc) "kill0screen_cols:= ;"
set Mfelectrics(sr) "kill0screen_rows:= ;"
set Mfelectrics(xpa) "kill0expandafter "

set Mfelectrics(for)  "  :  endfor;\n"
set Mfelectrics(def)   " =\n\nenddef;\n"
set Mfelectrics(prim)   "kill0primarydef =\n\nenddef;\n"
set Mfelectrics(sec)   "kill0secondarydef =\n\nenddef;\n"
set Mfelectrics(ter)   "kill0tertiarydef =\n\nenddef;\n"
set Mfelectrics(vardef)   " =\n\nenddef;\n"
set Mfelectrics(forever)   "  endfor;\n"
set Mfelectrics(forsuffixes)   "  :  endfor;\n"
set Mfelectrics(if)   "  :  fi\n"

# # # # # contractions # # # # #
set Mfelectrics(cu'n) "kill0currentpen "
set Mfelectrics(cu'p) "kill0currentpicture "
set Mfelectrics(cu't) "kill0currenttransform "
set Mfelectrics(cu'w) "kill0currentwindow "
set Mfelectrics(di'p) "kill0directionpoint "
set Mfelectrics(di't) "kill0directiontime "
set Mfelectrics(re'a) "kill0reflectedabout(,) "
set Mfelectrics(ro'a) "kill0rotatedaround(,) "


namespace eval Mf::Completion {}

# Proc to complete the 'input' instructions. Type 'input  xx'  and  the  proc
# will look for a known mf file  whose  name  starts  with  'xx'.  This  proc
# searches among the mf files in the source directory  defined  in  the  mode
# prefs (and in ALL its subfolders). If  the  source  directory  hasn't  been
# defined, it searches in the current folder and its subfolders.
proc Mf::Completion::Input {dummy} {
    global mf_params MfmodeVars
    if {!$MfmodeVars(buildSourceFiles)} {
	set mf_params(filenames) {}
	Mf::listSrcInDir [file dirname [win::Current]] mf
    }
    set mf_params(filenames) [join $mf_params(filenames)]
    regsub -all "  " $mf_params(filenames) " " mf_params(filenames)
    set cmd [completion::lastTwoWords begin]
    if {[string trim $begin] != "input" } { return 0 }
    completion::Find $cmd [completion::fromList $cmd mf_params(filenames)]
}	


# Key Bindings
# ------------

# We define Metafont specific key bindings : all of them
# use 'ctrl-m' followed by a letter.
# For instance, key bindings to choose the processing mode :
#    hit ctrl-m and then one of the letters p, s, l or u to select
#    respectively proof, smoke, localfont or user defined modes.
Bind 'm' <z> prefixChar Mf
Bind 'p' <M> {Mf::choosemodeProc "metafontMode" "proof"} Mf
Bind 's' <M> {Mf::choosemodeProc "metafontMode" "smoke"} Mf
Bind 'l' <M> {Mf::choosemodeProc "metafontMode" "localfont"} Mf
Bind 'u' <M> {Mf::choosemodeProc "metafontMode" "userDefined"} Mf
# Now key bindings to process the <b>uffer, a <f>ile or a <d>irectory :
# 'ctrl-m b', 'ctrl-m f' and 'ctrl-m d' respectively.
Bind 'b' <M> {Mf::menuProc "Metafont" "runTheBuffer"}
Bind 'f' <M> {Mf::menuProc "Metafont" "runAFile"}
Bind 'd' <M> {Mf::runafolderProc}
# A key binding ('ctrl-m n') to create a new font template :
Bind 'n' <M> {Mf::newtemplateProc} Mf
# A key binding ('ctrl-m m') to edit the <m>odes file modes.mf :
Bind 'm' <M> {Mf::openmodesmfProc} Mf
# A key binding ('ctrl-m c') to edit the macro <c>ommands file plain.mf :
Bind 'c' <M> {Mf::openplainmfProc} Mf
# A key binding ('ctrl-m g') to edit the log file :
Bind 'g' <M> {Mf::setnames [win::Current] ; Mf::editlogProc} Mf
# A key binding ('ctrl-m t') to convert <t>fm file to pl :
Bind 't' <M> {Mf::setnames [win::Current];Mf::doplProc;set mf_params(prefixpl) "";menu::buildSome convertFiles;Mf::editplProc} Mf
# A key binding ('ctrl-m i') to convert gf file to dv<i> :
Bind 'i' <M> {Mf::otherfilesProc "otherFiles" "convertGfToDvi"} Mf
# A key binding ('ctrl-m k') to convert gf file to p<k> :
Bind 'k' <M> {Mf::otherfilesProc "otherFiles" "convertGfToPk"} Mf
# A key binding ('ctrl-m v') to <v>iew the d<v>i :
Bind 'v' <M> {Mf::setnames [win::Current];Mf::viewdviProc} Mf



# File Marking
# ------------

# Marking is different in mf source files and in pl or vpl files.
# # # In mf source files :
# The 'def' and 'vardef' definitions are marked in the "M" menu (top right of
# the current window). All the 'beginchar/endchar' groups will be marked too.
# Even if you changed the name of these  'beginchar'  routines  in  the  mode
# specific prefs : for instance, if you chose to call them "myfontchar"  then
# all the "myfontchar" instructions will be marked.
# For a 'beginchar' instruction, the proc looks if there is a string  at  the
# end of the line (usually describing the char being designed) : if yes  mark
# this string, if not then mark the 'beginchar' and its character code.
# # # In property list files :
# the LIGTABLE and FONTDIMEN arrays are marked as  well  as  every  character
# dimensions data.

proc Mf::MarkFile {} {
    global MfmodeVars mf_params
    Mf::setnames [win::Current]
    if {$mf_params(extfilename) == ".mf"} {
	set bgnchar $MfmodeVars(userBeginchar)
	#  First mark the defs and vardefs
	set end [maxPos]
	set pos [minPos]
	while {![catch {search -s -f 1 -r 1 -m 0 -i 0 "^def \[ _\\w\]*|^vardef \[ _\\w\]*" $pos} res]} {
	    set start [lindex $res 0]
	    set end [lindex $res 1]
	    set txt [getText [pos::math $start - 1] $end]
	    set pos [nextLineStart $start]
	    set inds($txt) [lineStart [pos::math $start - 1]]
	}
	if {[info exists inds]} {
	    foreach f [lsort [array names inds]] {
		set next [nextLineStart $inds($f)]
		setNamedMark $f $inds($f) $next $next
	    }
	    unset inds
	}
	
	#  Then mark the 'beginchar' instructions
	set end [maxPos]
	set pos [minPos]
	while {![catch {eval [concat search -s -f 1 -r 1 -m 0 -i 0\
	  [list "^$bgnchar.*$"] $pos]} res]} {
	    set start [lindex $res 0]
	    set end [lindex $res 1]
	    set txt [getText [pos::math $start - 1] $end]
	    if {[regexp "$bgnchar" $txt]} {
		if {![regexp {; *\".*\" *;} $txt txt]} {
		    regexp "$bgnchar\[ _\\w\\d\\\(\\\"\]*" $txt txt 
		    set txt "$txt)"
		} else {
		    set txt [string trim $txt " ;\""]
		}
	    }
	    set pos [nextLineStart $start]
	    set inds($txt) [lineStart [pos::math $start - 1]]
	}
	if {[info exists inds]} {
	    foreach f [lsort [array names inds]] {
		set next [nextLineStart $inds($f)]
		setNamedMark $f $inds($f) $next $next
	    }
	}
    } else {
	set pos [minPos]
	set end [maxPos]
	while {![catch {search -s -f 1 -r 1 -m 0 -i 0 {^[\(](FONTDIMEN|LIGTABLE)} $pos} res]} {
	    set start [lindex $res 0]
	    set end [lindex $res 1]
	    set txt [getText [pos::math $start +1] $end]
	    set pos [nextLineStart $start]
	    set inds($txt) [lineStart [pos::math $start - 1]]
	}
	
	if {[info exists inds]} {
	    foreach f  [array names inds] {
		set next [nextLineStart $inds($f)]
		setNamedMark $f $inds($f) $next $next
	    }
	}
	
	set pos [minPos]
	set end [maxPos]
	while {![catch {search -s -f 1 -r 1 -m 0 -i 0 {^[\(]CHARACTER[ \w\d]*} $pos} res]} {
	    set start [lindex $res 0]
	    set end [lindex $res 1]
	    set txt [getText [pos::math $start +1] $end]
	    set pos [nextLineStart $start]
	    set inds($txt) [lineStart [pos::math $start - 1]]
	}
	
	if {[info exists inds]} {
	    foreach f [lsort -increasing [array names inds]] {
		set next [nextLineStart $inds($f)]
		setNamedMark $f $inds($f) $next $next
	    }
	}
    }
}


# The "{}" menu
# -------------

# The "{}" pop-up menu contains the functions defined in a  source  file.  We
# list here all the def and vardef definitions as well  as  the  files  input
# with an "input"  command.  Here  we  'lappend'  twice  on  purpose  because
# ::parseFuncs general proc takes one out of two :
proc Mf::parseFuncs {} {
    global funcExpr mf_params
    set mf_params(parse) 1
    set pos [minPos]
    set m {}
    while {[set res [search -s -f 1 -r 1 -i 0 -n "$funcExpr" $pos]] != ""} {
	lappend m "[eval getText $res]" [lindex $res 1]
	set pos [lindex $res 1]
    }
    set f [lsort -ignore [Mf::findInputFiles]]
    if {[llength $f]} {
	set f [linsert $f 0 "INPUT FILES : " "0"]
	set m [linsert $m 0 "-" "0"]
    }
    return [concat $f $m]
}

proc Mf::findInputFiles {} {
    global mf_params
    set files {}
    set pos [minPos]
	while {[set res [search -s -f 1 -r 1 -i 0 -n {^.*input.+$} $pos]] != ""} {
	set txt [eval getText $res]
	if {![regexp {^\%} $txt]} {
	    regsub -all "(^.*input +)" $txt "" txt
	    regsub -all " .+" $txt "" txt
	    lappend files $txt
	    if {$mf_params(parse)} {lappend files $txt}
	} 
	set pos [lindex $res 1]
    }
    set mf_params(parse) 0
    return $files
}


# Command-Double-click
# --------------------

# If you Command-Double-Click on a keyword you access  its  definition.  This
# proc looks first for a definition in the current file itself, then  in  the
# list of primitives, then in the plain Metafont macros file and  finally  in
# the other text files located in the same folder and called in  the  current
# file by an input command (typically they are macros files).

set mf_params(internals) [list "blacker" "currentwindow" "displaying" "eps" "epsilon" \
  "infinity" "join_radius" "number_of_modes" "o_correction" "pair" "path" "pen_bot"\
  "pen_lft" "pen_rt" "pen_top" "pixels_per_inch" "screen_cols" "screen_rows" "tolerance" ]

# # Abandoned :
# set mf_params(constants) [list "basename" "base_version" "blankpicture" "currentpen"\
#  "currentpen_path" "currenttransform" "ditto" "extra_beginchar" "extra_endchar"\
#  "extra_setup" "fullcircle" "halfcircle" "identity" "mode_name" "penspeck"\
#  "quartercircle" "rulepen" "unitpixel" "unitsquare" ]

proc Mf::DblClick {from to} {
    global MfmodeVars mf_params mfPrimList
    select $from $to
    set word [getText $from $to]
    set mf_params(parse) 0
    # First we look for the word's definition in the current file :
    set pos [minPos]
    if {![catch {eval [concat search -s -f 1 -r 1 -m 1 -i 0\
      [list "\(var|primary|secondary|tertiary\)?def\[ \\w\]+$word"] $pos]} res]} {
	goto [lineStart [lindex $res 0]]
	select [lindex $res 0] [lindex $res 1]
	return
    }
    # If search failed, check if it is a Metafont primitive.
    if {[expr {[lsearch -exact $mfPrimList "$word"] > -1}]} {
	alertnote "\"$word\" is a Metafont primitive.\rSee the MetafontBook."
	return
    }
    # If search failed, check if it is a 'newinternal'.
    if {[expr {[lsearch -exact $mf_params(internals) "$word"] > -1}]} {
	alertnote "\"$word\" is a constant of type \"newinternal\".\rSee the MetafontBook or Metapost User's Manual."
	return
    }
    # If search failed, look in the plain.mf macros file. Its path must
    # have been defined in the mode prefs.
    set f $MfmodeVars(pathToPlainMfFile)
    if {![file exists $f]} {
	alertnote "Can't find file plain.mf : where is it ?"
	catch {getfile "Find file plain.mf"} chemin
	if {$chemin == ""} {return}
	set pathToPlainMfFile $chemin
	set MfmodeVars(pathToPlainMfFile) [set chemin]
	prefs::modified MfmodeVars(pathToPlainMfFile)
    }    
    set cid [scancontext create]
    set searchstri "(var|primary|secondary|tertiary)?def\[ \\w\]+$word\[^\\w\]+"
    set searchstrii "(path|pen|picture|string|transform)\[ ,\\w\]+$word"
    scanmatch -- $cid $searchstri {set matches($f) 1}
    scanmatch -- $cid $searchstrii {set matches($f) 1}
    if {![catch {set fid [open $f]}]} {
	message "Looking at '[file tail $f]'"
	scanfile $cid $fid
	close $fid
    }
    if {[info exists matches]} {
	Mf::BringOrEdit $MfmodeVars(pathToPlainMfFile) -r
	goto $matchInfo(offset)
	set res [search -s -f 1 -r 0 -i 0 -m 1 -n $word $matchInfo(offset)]
	select $matchInfo(offset)] [lindex $res 1]
	unset matches
	return
    }
    # As a last resort, we search all the input files found in the source file provided
    # they are located in the same folder as the current file.
    set f [Mf::findInputFiles]
    if {[llength $f]} {
	foreach filetail $f {
	    set filetail [string trim $filetail ".mf"]
	    set fullname [file join [file dirname [win::Current]] $filetail.mf]
	    if {[file exists $fullname]} {
		if {![catch {set fid [open $fullname]}]} {
		    message "Looking at '$filetail'"
		    scanfile $cid $fid
		    close $fid
		}
	    } 
	    if {[info exists matches]} {
		Mf::BringOrEdit $fullname -r
		goto $matchInfo(offset)
		set res [search -s -f 1 -r 0 -i 0 -n $word $matchInfo(offset)]
		select $matchInfo(offset) [lindex $res 1]
		return
	    }	
	}
    }    
    scancontext delete $cid
    beep
    message "Could'nt find a definition for \"$word\"."
}


# Option-click on title bar
# -------------------------

# If you Option-Click on a the title bar, you get a list of all  the  mf  and
# log files located :
# - in the "local" folder (folder of currentwindow). 
# - in the "selected" folder (selected when you process an entire folder with
# "Run A Folder" or in the "Remove Files" sub menu)
# Selecting any item will open it in a window or bring its window to front if
# it is already open.

proc Mf::OptionTitlebar {} {
    global mf_params minItemsInTitlePopup
    set minItemsInTitlePopup 1
    set mf_params(sep) "-"
    set filesinlocaldir [glob -nocomplain -dir [file dirname [win::Current]] *.mf]
    set logsinlocaldir [glob -nocomplain -dir [file dirname [win::Current]] *.log]
    set filesinselecteddir {}
    set logsinselecteddir {}
    if {$mf_params(currentdir) !="" && $mf_params(currentdir)!=[file dirname [win::Current]]} {
	set filesinselecteddir [glob -nocomplain -dir $mf_params(currentdir) *.mf]
	set logsinselecteddir [glob -nocomplain -dir $mf_params(currentdir) *.log]
    }
    set l {}
    foreach f  $filesinlocaldir {
	lappend l [file tail $f]
    }
    foreach dir [list filesinselecteddir logsinlocaldir logsinselecteddir] {
	eval [concat "if \{\[llength \$$dir\]\} \{lappend l \$mf_params(sep) ; \
	  foreach f \$$dir \{lappend l \[file tail \$f\]\}\}"]	  
    }
    return $l
}

proc Mf::OptionTitlebarSelect {item} {
    global mf_params
    if {$item == $mf_params(sep)} {return}
    if {[file exists [file join [file dirname [win::Current]] $item]]} {
	Mf::BringOrEdit [file join [file dirname [win::Current]] $item] -c
    } else {
	Mf::BringOrEdit [file join $mf_params(currentdir) $item] -c
    }
}

proc Mf::BringOrEdit {name {type ""}} {
    catch {lsearch -exact [winNames] [file tail $name]} indx
    if {[expr {$indx > -1}]} {
	bringToFront [file tail $name]
    } else {
	edit $type $name
    }
}


# ---------------------------------------------------------------
# Now we call the file containing the Metafont menu definitions
# ---------------------------------------------------------------
if {![alpha::tryToLoad "Initializing Metafont mode" mfMenus.tcl {}]} {
    alertnote "Error: the Metafont menu did not properly load."
}

message "Mf mode initialization complete."
